//Light position
uniform vec2 u_lightCenter;
//Light half size 
uniform vec2 u_lightSizeUV;

//vertex position
varying vec4 v_vertexPos;
//tex coord
varying vec2 v_texCoord;

//norm tex coords
varying vec2 v_normTexCoord;

#define PI 3.1415926535897932384626433832795
#define OCCLUSION_SIZE 128.0

const float solidThreshold = 0.5;

void main(void) {
    float distance = 1.0;
    int hitCount = 0;
    float theta = v_normTexCoord.x * PI;
    float sinTheta = sin(theta);
    float cosTheta = cos(theta);
    
//    //Loops limits should be constant
      for (float y = 7.0; y < OCCLUSION_SIZE; y += 1.0) {
       //rectangular to polar and sampling
       float r = y / OCCLUSION_SIZE ;
       vec2 coord = vec2(r * cosTheta *u_lightSizeUV.x , r * sinTheta*u_lightSizeUV.y);
       vec4 data = texture2D(CC_Texture1, coord + u_lightCenter);
//        
//       //smallest distance to occluder
//       //distance = min(distance,mix(1.0, r * data.a, data.a));
//       
        if(data.a > solidThreshold ){
            hitCount++;
            if(hitCount == 11){
                distance = r;
                break;
            }
        }
       if(data.a <= solidThreshold){
            if(hitCount > 0){
                distance = r;
                break;
            }
        }

    }
    gl_FragColor = vec4(distance, distance, distance, 1.0);
        
}
